/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.ai.goals.jobs;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.Vector2;
import java.util.Iterator;
import technology.rocketjump.undermount.assets.entities.item.model.ItemPlacement;
import technology.rocketjump.undermount.entities.behaviour.furniture.CraftingStationBehaviour;
import technology.rocketjump.undermount.entities.components.FurnitureInventoryComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.ai.goals.Goal;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalException;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalFailedException;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalInterruptedException;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HaulingComponent;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.messaging.types.EntityMessage;
import technology.rocketjump.undermount.rooms.ItemAllocation;

public class PlaceItemGoal
extends Goal {
    private static final Vector2 DOWN = new Vector2(0.0f, -1.0f);
    private final ItemAllocation itemAllocation;
    private final TiledMap map;
    private final MessageDispatcher messageDispatcher;

    public PlaceItemGoal(Entity parentEntity, MessageDispatcher messageDispatcher, ItemAllocation itemAllocation, TiledMap areaMap) {
        super(parentEntity);
        this.messageDispatcher = messageDispatcher;
        this.itemAllocation = itemAllocation;
        this.map = areaMap;
    }

    @Override
    public void update(float deltaTimeSeconds) throws GoalException {
        HaulingComponent haulingComponent = this.parentEntity.getComponent(HaulingComponent.class);
        if (haulingComponent == null || haulingComponent.getHauledItem() == null) {
            return;
        }
        Entity itemToPlace = haulingComponent.getHauledItem();
        ItemEntityAttributes itemToPlaceAttributes = (ItemEntityAttributes)itemToPlace.getPhysicalEntityComponent().getAttributes();
        MapTile currentTile = this.map.getTile(this.parentEntity.getLocationComponent().getWorldPosition());
        if (this.itemAllocation != null && !currentTile.getTilePosition().equals(this.itemAllocation.getTargetPosition())) {
            throw new GoalFailedException("Not in expected tile to place item");
        }
        if (this.itemAllocation != null && this.itemAllocation.getTargetType().equals((Object)ItemAllocation.AllocationTargetType.FURNITURE)) {
            this.placeItemInFurniture(haulingComponent, itemToPlace, currentTile);
        } else if (currentTile.hasItem()) {
            Entity itemAlreadyInTile = currentTile.getItemMatching(itemToPlaceAttributes);
            if (itemAlreadyInTile == null) {
                this.goalInterrupted("Some other item already in target placement tile");
            } else {
                ItemEntityAttributes itemInTileAttributes = (ItemEntityAttributes)itemAlreadyInTile.getPhysicalEntityComponent().getAttributes();
                if (itemInTileAttributes.getQuantity() + itemToPlaceAttributes.getQuantity() > itemInTileAttributes.getItemType().getMaxStackSize()) {
                    this.goalInterrupted("Some other item already in target placement tile");
                } else {
                    itemInTileAttributes.setQuantity(itemInTileAttributes.getQuantity() + itemToPlaceAttributes.getQuantity());
                    if (currentTile.hasConstruction()) {
                        itemInTileAttributes.setNumAllocated(itemInTileAttributes.getQuantity());
                    }
                    this.messageDispatcher.dispatchMessage(null, 324, (Object)itemAlreadyInTile);
                    haulingComponent.clearHauledItem();
                    this.parentEntity.removeComponent(HaulingComponent.class);
                    this.messageDispatcher.dispatchMessage(null, 322, (Object)new EntityMessage(itemToPlace.getId()));
                }
            }
        } else if (!currentTile.isEmpty() && !currentTile.hasConstruction()) {
            this.goalInterrupted("Something already in target placement tile");
        } else {
            itemToPlace.getLocationComponent().setWorldPosition(currentTile.getWorldPositionOfCenter().cpy(), false);
            itemToPlace.getLocationComponent().setFacing(DOWN);
            itemToPlaceAttributes.setItemPlacement(ItemPlacement.ON_GROUND);
            itemToPlaceAttributes.setNumAllocated(0);
            if (currentTile.hasConstruction()) {
                itemToPlaceAttributes.setNumAllocated(itemToPlaceAttributes.getQuantity());
            }
            this.messageDispatcher.dispatchMessage(324, itemToPlace);
            currentTile.addEntity(itemToPlace);
            haulingComponent.clearHauledItem();
            this.parentEntity.removeComponent(HaulingComponent.class);
        }
    }

    private void placeItemInFurniture(HaulingComponent haulingComponent, Entity itemToPlace, MapTile currentTile) throws GoalInterruptedException {
        MapTile neighbourTile;
        Long targetFurnitureId = this.itemAllocation.getTargetId();
        Entity targetFurniture = null;
        Iterator iterator = this.map.getNeighbours(currentTile.getTileX(), currentTile.getTileY()).values().iterator();
        while (iterator.hasNext() && (targetFurniture = (neighbourTile = (MapTile)iterator.next()).getEntity(targetFurnitureId)) == null) {
        }
        if (targetFurniture == null) {
            this.goalInterrupted("Could not find furniture to place item into");
        } else {
            FurnitureInventoryComponent inventoryComponent = targetFurniture.getOrCreateComponent(FurnitureInventoryComponent.class);
            try {
                inventoryComponent.add(itemToPlace, this.messageDispatcher);
                haulingComponent.clearHauledItem();
                if (targetFurniture.getBehaviourComponent() instanceof CraftingStationBehaviour) {
                    CraftingStationBehaviour craftingStationBehaviour = (CraftingStationBehaviour)targetFurniture.getBehaviourComponent();
                    craftingStationBehaviour.itemAdded(this.map);
                }
            }
            catch (FurnitureInventoryComponent.NotEnoughInventorySpaceException e) {
                this.goalInterrupted("Could not add item to inventory component due to space");
            }
        }
    }

    private void goalInterrupted(String message) throws GoalInterruptedException {
        if (this.itemAllocation != null) {
            this.messageDispatcher.dispatchMessage(null, 701, (Object)this.itemAllocation);
        }
        throw new GoalInterruptedException(message);
    }

    @Override
    public boolean isComplete() {
        HaulingComponent haulingComponent = this.parentEntity.getComponent(HaulingComponent.class);
        return haulingComponent == null || haulingComponent.getHauledItem() == null;
    }
}

